/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.CommDriver;
import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.LPRPort;
import gnu.io.PortInUseException;
import gnu.io.RXTXPort;
import gnu.io.RXTXVersion;
import java.io.File;
import java.io.FileInputStream;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class RXTXCommDriver
implements CommDriver {
    private static final boolean debug = true;
    private static final boolean devel = false;
    private static final boolean noVersionOutput;
    private String deviceDirectory;
    private String osName;

    private native boolean registerKnownPorts(int var1);

    private native boolean isPortPrefixValid(String var1);

    private native boolean testRead(String var1, int var2);

    private native String getDeviceDirectory();

    public static native String nativeGetVersion();

    private final String[] getValidPortPrefixes(String[] stringArray) {
        String[] stringArray2 = new String[256];
        System.out.println("\nRXTXCommDriver:getValidPortPrefixes()");
        if (stringArray == null) {
            System.out.println("\nRXTXCommDriver:getValidPortPrefixes() No ports prefixes known for this System.\nPlease check the port prefixes listed for " + this.osName + " in RXTXCommDriver:registerScannedPorts()\n");
        }
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.isPortPrefixValid(stringArray[i])) continue;
            stringArray2[n++] = stringArray[i];
        }
        String[] stringArray3 = new String[n];
        System.arraycopy(stringArray2, 0, stringArray3, 0, n);
        if (stringArray2[0] == null) {
            System.out.println("\nRXTXCommDriver:getValidPortPrefixes() No ports matched the list assumed for this\nSystem in the directory " + this.deviceDirectory + ".  Please check the ports listed for \"" + this.osName + "\" in\nRXTXCommDriver:registerScannedPorts()\nTried:");
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("\t" + stringArray[n]);
            }
        } else {
            System.out.println("\nRXTXCommDriver:getValidPortPrefixes()\nThe following port prefixes have been identified as valid on " + this.osName + ":\n");
        }
        return stringArray3;
    }

    private void checkSolaris(String string, int n) {
        char[] cArray = new char[]{'['};
        cArray[0] = 97;
        while (cArray[0] < '{') {
            if (this.testRead(string.concat(new String(cArray)), n)) {
                CommPortIdentifier.addPortName(string.concat(new String(cArray)), n, this);
            }
            cArray[0] = (char)(cArray[0] + '\u0001');
        }
        cArray[0] = 48;
        while (cArray[0] <= '9') {
            if (this.testRead(string.concat(new String(cArray)), n)) {
                CommPortIdentifier.addPortName(string.concat(new String(cArray)), n, this);
            }
            cArray[0] = (char)(cArray[0] + '\u0001');
        }
    }

    private void registerValidPorts(String[] stringArray, String[] stringArray2, int n) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        System.out.println("Entering registerValidPorts()");
        System.out.println(" Candidate devices:");
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            System.out.println("  " + stringArray[n2]);
        }
        System.out.println(" valid port prefixes:");
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            System.out.println("  " + stringArray2[n2]);
        }
        if (stringArray != null && stringArray2 != null) {
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                for (n4 = 0; n4 < stringArray2.length; ++n4) {
                    String string = stringArray2[n4];
                    int n5 = string.length();
                    String string2 = stringArray[n3];
                    if (string2.length() < n5) continue;
                    String string3 = string2.substring(n5).toUpperCase();
                    String string4 = string2.substring(n5).toLowerCase();
                    if (!string2.regionMatches(0, string, 0, n5) || !string3.equals(string4)) continue;
                    String string5 = this.osName.toLowerCase().indexOf("windows") == -1 ? this.deviceDirectory + string2 : string2;
                    System.out.println(string2 + " " + string);
                    System.out.println(string3 + " " + string4);
                    if (this.osName.equals("Solaris") || this.osName.equals("SunOS")) {
                        this.checkSolaris(string5, n);
                        continue;
                    }
                    if (!this.testRead(string5, n)) continue;
                    CommPortIdentifier.addPortName(string5, n, this);
                }
            }
        }
        System.out.println("Leaving registerValidPorts()");
    }

    public void initialize() {
        System.out.println("RXTXCommDriver:initialize()");
        this.osName = System.getProperty("os.name");
        this.deviceDirectory = this.getDeviceDirectory();
        for (int i = 1; i <= 2; ++i) {
            if (this.registerSpecifiedPorts(i) || this.registerKnownPorts(i)) continue;
            this.registerScannedPorts(i);
        }
    }

    private void addSpecifiedPorts(String string, int n) {
        String string2 = System.getProperty("path.separator", ":");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        System.out.println("\nRXTXCommDriver:addSpecifiedPorts()");
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            if (!this.testRead(string3, n)) continue;
            CommPortIdentifier.addPortName(string3, n, this);
        }
    }

    private boolean registerSpecifiedPorts(int n) {
        String string = null;
        Properties properties = System.getProperties();
        try {
            String string2 = System.getProperty("java.ext.dirs") + System.getProperty("file.separator");
            FileInputStream fileInputStream = new FileInputStream(string2 + "gnu.io.rxtx.properties");
            Properties properties2 = new Properties();
            properties2.load(fileInputStream);
            System.setProperties(properties2);
            Iterator<Object> iterator = properties2.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                System.setProperty(string3, properties2.getProperty(string3));
            }
        }
        catch (Exception exception) {
            System.out.println("The file: gnu.io.rxtx.properties doesn't exists.");
            System.out.println(exception.toString());
        }
        System.out.println("checking for system-known ports of type " + n);
        System.out.println("checking registry for ports of type " + n);
        switch (n) {
            case 1: {
                string = System.getProperty("gnu.io.rxtx.SerialPorts");
                if (string != null) break;
                string = System.getProperty("gnu.io.SerialPorts");
                break;
            }
            case 2: {
                string = System.getProperty("gnu.io.rxtx.ParallelPorts");
                if (string != null) break;
                string = System.getProperty("gnu.io.ParallelPorts");
                break;
            }
            default: {
                System.out.println("unknown port type " + n + " passed to RXTXCommDriver.registerSpecifiedPorts()");
            }
        }
        System.setProperties(properties);
        if (string != null) {
            this.addSpecifiedPorts(string, n);
            return true;
        }
        return false;
    }

    private void registerScannedPorts(int n) {
        String[] stringArray;
        Object object;
        System.out.println("scanning device directory " + this.deviceDirectory + " for ports of type " + n);
        if (this.osName.equals("Windows CE")) {
            object = new String[]{"COM1:", "COM2:", "COM3:", "COM4:", "COM5:", "COM6:", "COM7:", "COM8:"};
            stringArray = object;
        } else if (this.osName.toLowerCase().indexOf("windows") != -1) {
            int n2;
            object = new String[259];
            for (n2 = 1; n2 <= 256; ++n2) {
                object[n2 - 1] = "COM" + n2;
            }
            for (n2 = 1; n2 <= 3; ++n2) {
                object[n2 + 255] = "LPT" + n2;
            }
            stringArray = object;
        } else if (this.osName.equals("Solaris") || this.osName.equals("SunOS")) {
            object = new String[2];
            int n3 = 0;
            File file = null;
            file = new File("/dev/term");
            if (file.list().length > 0) {
                object[n3++] = "term/";
            }
            String[] stringArray2 = new String[n3];
            --n3;
            while (n3 >= 0) {
                stringArray2[n3] = object[n3];
                --n3;
            }
            stringArray = stringArray2;
        } else {
            object = new File(this.deviceDirectory);
            String[] stringArray3 = ((File)object).list();
            stringArray = stringArray3;
        }
        if (stringArray == null) {
            System.out.println("RXTXCommDriver:registerScannedPorts() no Device files to check ");
            return;
        }
        object = new String[]{};
        switch (n) {
            case 1: {
                System.out.println("scanning for serial ports for os " + this.osName);
                if (this.osName.equals("Linux")) {
                    String[] stringArray4 = new String[]{"ttyS", "ttySA", "ttyUSB", "rfcomm", "ttyircomm", "ttyACM"};
                    object = stringArray4;
                    break;
                }
                if (this.osName.equals("Linux-all-ports")) {
                    String[] stringArray5 = new String[]{"comx", "holter", "modem", "rfcomm", "ttyircomm", "ttycosa0c", "ttycosa1c", "ttyACM", "ttyC", "ttyCH", "ttyD", "ttyE", "ttyF", "ttyH", "ttyI", "ttyL", "ttyM", "ttyMX", "ttyP", "ttyR", "ttyS", "ttySI", "ttySR", "ttyT", "ttyUSB", "ttyV", "ttyW", "ttyX"};
                    object = stringArray5;
                    break;
                }
                if (this.osName.toLowerCase().indexOf("qnx") != -1) {
                    String[] stringArray6 = new String[]{"ser"};
                    object = stringArray6;
                    break;
                }
                if (this.osName.equals("Irix")) {
                    String[] stringArray7 = new String[]{"ttyc", "ttyd", "ttyf", "ttym", "ttyq", "tty4d", "tty4f", "midi", "us"};
                    object = stringArray7;
                    break;
                }
                if (this.osName.equals("FreeBSD")) {
                    String[] stringArray8 = new String[]{"ttyd", "cuaa", "ttyA", "cuaA", "ttyD", "cuaD", "ttyE", "cuaE", "ttyF", "cuaF", "ttyR", "cuaR", "stl"};
                    object = stringArray8;
                    break;
                }
                if (this.osName.equals("NetBSD")) {
                    String[] stringArray9 = new String[]{"tty0"};
                    object = stringArray9;
                    break;
                }
                if (this.osName.equals("Solaris") || this.osName.equals("SunOS")) {
                    String[] stringArray10 = new String[]{"term/", "cua/"};
                    object = stringArray10;
                    break;
                }
                if (this.osName.equals("HP-UX")) {
                    String[] stringArray11 = new String[]{"tty0p", "tty1p"};
                    object = stringArray11;
                    break;
                }
                if (this.osName.equals("UnixWare") || this.osName.equals("OpenUNIX")) {
                    String[] stringArray12 = new String[]{"tty00s", "tty01s", "tty02s", "tty03s"};
                    object = stringArray12;
                    break;
                }
                if (this.osName.equals("OpenServer")) {
                    String[] stringArray13 = new String[]{"tty1A", "tty2A", "tty3A", "tty4A", "tty5A", "tty6A", "tty7A", "tty8A", "tty9A", "tty10A", "tty11A", "tty12A", "tty13A", "tty14A", "tty15A", "tty16A", "ttyu1A", "ttyu2A", "ttyu3A", "ttyu4A", "ttyu5A", "ttyu6A", "ttyu7A", "ttyu8A", "ttyu9A", "ttyu10A", "ttyu11A", "ttyu12A", "ttyu13A", "ttyu14A", "ttyu15A", "ttyu16A"};
                    object = stringArray13;
                    break;
                }
                if (this.osName.equals("Compaq's Digital UNIX") || this.osName.equals("OSF1")) {
                    String[] stringArray14 = new String[]{"tty0"};
                    object = stringArray14;
                    break;
                }
                if (this.osName.equals("BeOS")) {
                    String[] stringArray15 = new String[]{"serial"};
                    object = stringArray15;
                    break;
                }
                if (this.osName.equals("Mac OS X")) {
                    String[] stringArray16 = new String[]{"cu.KeyUSA28X191.", "tty.KeyUSA28X191.", "cu.KeyUSA28X181.", "tty.KeyUSA28X181.", "cu.KeyUSA19181.", "tty.KeyUSA19181."};
                    object = stringArray16;
                    break;
                }
                if (this.osName.toLowerCase().indexOf("windows") != -1) {
                    String[] stringArray17 = new String[]{"COM"};
                    object = stringArray17;
                    break;
                }
                System.out.println("No valid prefixes for serial ports have been entered for " + this.osName + " in RXTXCommDriver.java.  This may just be a typo in the method registerScanPorts().");
                break;
            }
            case 2: {
                System.out.println("scanning for parallel ports for os " + this.osName);
                if (this.osName.equals("Linux")) {
                    String[] stringArray18 = new String[]{"lp"};
                    object = stringArray18;
                    break;
                }
                if (this.osName.equals("FreeBSD")) {
                    String[] stringArray19 = new String[]{"lpt"};
                    object = stringArray19;
                    break;
                }
                if (this.osName.toLowerCase().indexOf("windows") != -1) {
                    String[] stringArray20 = new String[]{"LPT"};
                    object = stringArray20;
                    break;
                }
                String[] stringArray21 = new String[]{};
                object = stringArray21;
                break;
            }
            default: {
                System.out.println("Unknown PortType " + n + " passed to RXTXCommDriver.registerScannedPorts()");
            }
        }
        this.registerValidPorts(stringArray, (String[])object, n);
    }

    public CommPort getCommPort(String string, int n) {
        System.out.println("RXTXCommDriver:getCommPort(" + string + "," + n + ")");
        try {
            switch (n) {
                case 1: {
                    if (this.osName.toLowerCase().indexOf("windows") == -1) {
                        return new RXTXPort(string);
                    }
                    return new RXTXPort(this.deviceDirectory + string);
                }
                case 2: {
                    return new LPRPort(string);
                }
            }
            System.out.println("unknown PortType  " + n + " passed to RXTXCommDriver.getCommPort()");
        }
        catch (PortInUseException portInUseException) {
            System.out.println("Port " + string + " in use by another application");
        }
        return null;
    }

    public void Report(String string) {
        System.out.println(string);
    }

    static {
        String string;
        noVersionOutput = "true".equals(System.getProperty("gnu.io.rxtx.NoVersionOutput"));
        System.out.println("RXTXCommDriver {}");
        System.loadLibrary("rxtxSerial");
        String string2 = RXTXVersion.getVersion();
        try {
            string = RXTXVersion.nativeGetVersion();
        }
        catch (Error error) {
            string = RXTXCommDriver.nativeGetVersion();
        }
        if (!string2.equals(string)) {
            System.out.println("WARNING:  RXTX Version mismatch\n\tJar version = " + string2 + "\n\tnative lib Version = " + string);
        } else {
            System.out.println("RXTXCommDriver:\n\tJar version = " + string2 + "\n\tnative lib Version = " + string);
        }
    }
}

