/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import gnu.io.Zystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;

public final class RXTXPort
extends SerialPort {
    protected static final boolean debug = true;
    protected static final boolean debug_read = true;
    protected static final boolean debug_read_results = true;
    protected static final boolean debug_write = true;
    protected static final boolean debug_events = true;
    protected static final boolean debug_verbose = true;
    private static Zystem z;
    boolean MonitorThreadAlive = false;
    int IOLocked = 0;
    Object IOLockedMutex = new Object();
    private int fd = 0;
    long eis = 0L;
    int pid = 0;
    static boolean dsrFlag;
    private final SerialOutputStream out = new SerialOutputStream();
    private final SerialInputStream in = new SerialInputStream();
    private int speed = 9600;
    private int dataBits = 8;
    private int stopBits = 1;
    private int parity = 0;
    private int flowmode = 0;
    private int timeout;
    private int threshold = 0;
    private int InputBuffer = 0;
    private int OutputBuffer = 0;
    private SerialPortEventListener SPEventListener;
    private MonitorThread monThread;
    boolean monThreadisInterrupted = true;
    boolean MonitorThreadLock = true;
    boolean closeLock = false;

    private static native void Initialize();

    public RXTXPort(String string) throws PortInUseException {
        z.reportln("RXTXPort:RXTXPort(" + string + ") called");
        this.fd = this.open(string);
        this.name = string;
        this.MonitorThreadLock = true;
        this.monThread = new MonitorThread();
        this.monThread.start();
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadAlive = true;
        this.timeout = -1;
        z.reportln("RXTXPort:RXTXPort(" + string + ") returns with fd = " + this.fd);
    }

    private synchronized native int open(String var1) throws PortInUseException;

    public OutputStream getOutputStream() {
        z.reportln("RXTXPort:getOutputStream() called and returning");
        return this.out;
    }

    public InputStream getInputStream() {
        z.reportln("RXTXPort:getInputStream() called and returning");
        return this.in;
    }

    private native int nativeGetParity(int var1);

    private native int nativeGetFlowControlMode(int var1);

    public synchronized void setSerialPortParams(int n, int n2, int n3, int n4) throws UnsupportedCommOperationException {
        z.reportln("RXTXPort:setSerialPortParams(" + n + " " + n2 + " " + n3 + " " + n4 + ") called");
        if (this.nativeSetSerialPortParams(n, n2, n3, n4)) {
            throw new UnsupportedCommOperationException("Invalid Parameter");
        }
        this.speed = n;
        this.dataBits = n3 == 3 ? 5 : n2;
        this.stopBits = n3;
        this.parity = n4;
        z.reportln("RXTXPort:setSerialPortParams(" + n + " " + n2 + " " + n3 + " " + n4 + ") returning");
    }

    private native boolean nativeSetSerialPortParams(int var1, int var2, int var3, int var4) throws UnsupportedCommOperationException;

    public int getBaudRate() {
        z.reportln("RXTXPort:getBaudRate() called and returning " + this.speed);
        return this.speed;
    }

    public int getDataBits() {
        z.reportln("RXTXPort:getDataBits() called and returning " + this.dataBits);
        return this.dataBits;
    }

    public int getStopBits() {
        z.reportln("RXTXPort:getStopBits() called and returning " + this.stopBits);
        return this.stopBits;
    }

    public int getParity() {
        z.reportln("RXTXPort:getParity() called and returning " + this.parity);
        return this.parity;
    }

    public void setFlowControlMode(int n) {
        z.reportln("RXTXPort:setFlowControlMode( " + n + " ) called");
        if (this.monThreadisInterrupted) {
            z.reportln("RXTXPort:setFlowControlMode MonThread is Interrupeted returning");
            return;
        }
        try {
            this.setflowcontrol(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        this.flowmode = n;
        z.reportln("RXTXPort:setFlowControlMode( " + n + " ) returning");
    }

    public int getFlowControlMode() {
        z.reportln("RXTXPort:getFlowControlMode() returning " + this.flowmode);
        return this.flowmode;
    }

    native void setflowcontrol(int var1) throws IOException;

    public void enableReceiveFraming(int n) throws UnsupportedCommOperationException {
        z.reportln("RXTXPort:enableReceiveFramming() throwing exception");
        throw new UnsupportedCommOperationException("Not supported");
    }

    public void disableReceiveFraming() {
        z.reportln("RXTXPort:disableReceiveFramming() called and returning (noop)");
    }

    public boolean isReceiveFramingEnabled() {
        z.reportln("RXTXPort:isReceiveFrammingEnabled() called and returning false");
        return false;
    }

    public int getReceiveFramingByte() {
        z.reportln("RXTXPort:getReceiveFrammingByte() called and returning 0");
        return 0;
    }

    public native int NativegetReceiveTimeout();

    private native boolean NativeisReceiveTimeoutEnabled();

    private native void NativeEnableReceiveTimeoutThreshold(int var1, int var2, int var3);

    public void disableReceiveTimeout() {
        z.reportln("RXTXPort:disableReceiveTimeout() called");
        this.timeout = -1;
        this.NativeEnableReceiveTimeoutThreshold(this.timeout, this.threshold, this.InputBuffer);
        z.reportln("RXTXPort:disableReceiveTimeout() returning");
    }

    public void enableReceiveTimeout(int n) {
        z.reportln("RXTXPort:enableReceiveTimeout() called");
        if (n < 0) {
            throw new IllegalArgumentException("Unexpected negative timeout value");
        }
        this.timeout = n;
        this.NativeEnableReceiveTimeoutThreshold(n, this.threshold, this.InputBuffer);
        z.reportln("RXTXPort:enableReceiveTimeout() returning");
    }

    public boolean isReceiveTimeoutEnabled() {
        z.reportln("RXTXPort:isReceiveTimeoutEnabled() called and returning " + this.NativeisReceiveTimeoutEnabled());
        return this.NativeisReceiveTimeoutEnabled();
    }

    public int getReceiveTimeout() {
        z.reportln("RXTXPort:getReceiveTimeout() called and returning " + this.NativegetReceiveTimeout());
        return this.NativegetReceiveTimeout();
    }

    public void enableReceiveThreshold(int n) {
        z.reportln("RXTXPort:enableReceiveThreshold( " + n + " ) called");
        if (n < 0) {
            throw new IllegalArgumentException("Unexpected negative threshold value");
        }
        this.threshold = n;
        this.NativeEnableReceiveTimeoutThreshold(this.timeout, this.threshold, this.InputBuffer);
        z.reportln("RXTXPort:enableReceiveThreshold( " + n + " ) returned");
    }

    public void disableReceiveThreshold() {
        z.reportln("RXTXPort:disableReceiveThreshold() called and returning");
        this.enableReceiveThreshold(0);
    }

    public int getReceiveThreshold() {
        z.reportln("RXTXPort:getReceiveThreshold() called and returning " + this.threshold);
        return this.threshold;
    }

    public boolean isReceiveThresholdEnabled() {
        z.reportln("RXTXPort:isReceiveThresholdEnable() called and returning" + (this.threshold > 0));
        return this.threshold > 0;
    }

    public void setInputBufferSize(int n) {
        z.reportln("RXTXPort:setInputBufferSize( " + n + ") called");
        if (n < 0) {
            throw new IllegalArgumentException("Unexpected negative buffer size value");
        }
        this.InputBuffer = n;
        z.reportln("RXTXPort:setInputBufferSize( " + n + ") returning");
    }

    public int getInputBufferSize() {
        z.reportln("RXTXPort:getInputBufferSize() called and returning " + this.InputBuffer);
        return this.InputBuffer;
    }

    public void setOutputBufferSize(int n) {
        z.reportln("RXTXPort:setOutputBufferSize( " + n + ") called");
        if (n < 0) {
            throw new IllegalArgumentException("Unexpected negative buffer size value");
        }
        this.OutputBuffer = n;
        z.reportln("RXTXPort:setOutputBufferSize( " + n + ") returned");
    }

    public int getOutputBufferSize() {
        z.reportln("RXTXPort:getOutputBufferSize() called and returning " + this.OutputBuffer);
        return this.OutputBuffer;
    }

    public native boolean isDTR();

    public native void setDTR(boolean var1);

    public native void setRTS(boolean var1);

    private native void setDSR(boolean var1);

    public native boolean isCTS();

    public native boolean isDSR();

    public native boolean isCD();

    public native boolean isRI();

    public native boolean isRTS();

    public native void sendBreak(int var1);

    protected native void writeByte(int var1, boolean var2) throws IOException;

    protected native void writeArray(byte[] var1, int var2, int var3, boolean var4) throws IOException;

    protected native boolean nativeDrain(boolean var1) throws IOException;

    protected native int nativeavailable() throws IOException;

    protected native int readByte() throws IOException;

    protected native int readArray(byte[] var1, int var2, int var3) throws IOException;

    protected native int readTerminatedArray(byte[] var1, int var2, int var3, byte[] var4) throws IOException;

    native void eventLoop();

    private native void interruptEventLoop();

    public boolean checkMonitorThread() {
        z.reportln("RXTXPort:checkMonitorThread()");
        if (this.monThread != null) {
            z.reportln("monThreadisInterrupted = " + this.monThreadisInterrupted);
            return this.monThreadisInterrupted;
        }
        z.reportln("monThread is null ");
        return true;
    }

    public boolean sendEvent(int n, boolean bl) {
        z.report("RXTXPort:sendEvent(");
        if (this.fd == 0 || this.SPEventListener == null || this.monThread == null) {
            return true;
        }
        switch (n) {
            case 1: {
                z.reportln("DATA_AVAILABLE " + this.monThread.Data + ")");
                break;
            }
            case 2: {
                z.reportln("OUTPUT_BUFFER_EMPTY " + this.monThread.Output + ")");
                break;
            }
            case 3: {
                z.reportln("CTS " + this.monThread.CTS + ")");
                break;
            }
            case 4: {
                z.reportln("DSR " + this.monThread.Output + ")");
                break;
            }
            case 5: {
                z.reportln("RI " + this.monThread.RI + ")");
                break;
            }
            case 6: {
                z.reportln("CD " + this.monThread.CD + ")");
                break;
            }
            case 7: {
                z.reportln("OE " + this.monThread.OE + ")");
                break;
            }
            case 8: {
                z.reportln("PE " + this.monThread.PE + ")");
                break;
            }
            case 9: {
                z.reportln("FE " + this.monThread.FE + ")");
                break;
            }
            case 10: {
                z.reportln("BI " + this.monThread.BI + ")");
                break;
            }
            default: {
                z.reportln("XXXXXXXXXXXXXX " + n + ")");
            }
        }
        z.reportln("\tchecking flags ");
        switch (n) {
            case 1: {
                if (this.monThread.Data) break;
                return false;
            }
            case 2: {
                if (this.monThread.Output) break;
                return false;
            }
            case 3: {
                if (this.monThread.CTS) break;
                return false;
            }
            case 4: {
                if (this.monThread.DSR) break;
                return false;
            }
            case 5: {
                if (this.monThread.RI) break;
                return false;
            }
            case 6: {
                if (this.monThread.CD) break;
                return false;
            }
            case 7: {
                if (this.monThread.OE) break;
                return false;
            }
            case 8: {
                if (this.monThread.PE) break;
                return false;
            }
            case 9: {
                if (this.monThread.FE) break;
                return false;
            }
            case 10: {
                if (this.monThread.BI) break;
                return false;
            }
            default: {
                System.err.println("unknown event: " + n);
                return false;
            }
        }
        z.reportln("\tgetting event");
        SerialPortEvent serialPortEvent = new SerialPortEvent(this, n, !bl, bl);
        z.reportln("\tsending event");
        if (this.monThreadisInterrupted) {
            z.reportln("\tsendEvent return");
            return true;
        }
        if (this.SPEventListener != null) {
            this.SPEventListener.serialEvent(serialPortEvent);
        }
        z.reportln("\tsendEvent return");
        return this.fd == 0 || this.SPEventListener == null || this.monThread == null;
    }

    public void addEventListener(SerialPortEventListener serialPortEventListener) throws TooManyListenersException {
        z.reportln("RXTXPort:addEventListener()");
        if (this.SPEventListener != null) {
            throw new TooManyListenersException();
        }
        this.SPEventListener = serialPortEventListener;
        if (!this.MonitorThreadAlive) {
            this.MonitorThreadLock = true;
            this.monThread = new MonitorThread();
            this.monThread.start();
            this.waitForTheNativeCodeSilly();
            this.MonitorThreadAlive = true;
        }
        z.reportln("RXTXPort:Interrupt=false");
    }

    public void removeEventListener() {
        z.reportln("RXTXPort:removeEventListener() called");
        this.waitForTheNativeCodeSilly();
        if (this.monThreadisInterrupted) {
            z.reportln("\tRXTXPort:removeEventListener() already interrupted");
            this.monThread = null;
            this.SPEventListener = null;
            return;
        }
        if (this.monThread != null && this.monThread.isAlive()) {
            z.reportln("\tRXTXPort:Interrupt=true");
            this.monThreadisInterrupted = true;
            z.reportln("\tRXTXPort:calling interruptEventLoop");
            this.interruptEventLoop();
            z.reportln("\tRXTXPort:calling monThread.join()");
            try {
                this.monThread.join(3000L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return;
            }
            if (this.monThread.isAlive()) {
                z.reportln("\tMonThread is still alive!");
            }
        }
        this.monThread = null;
        this.SPEventListener = null;
        this.MonitorThreadLock = false;
        this.MonitorThreadAlive = false;
        this.monThreadisInterrupted = true;
        z.reportln("RXTXPort:removeEventListener() returning");
    }

    protected void waitForTheNativeCodeSilly() {
        while (this.MonitorThreadLock) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {}
        }
    }

    private native void nativeSetEventFlag(int var1, int var2, boolean var3);

    public void notifyOnDataAvailable(boolean bl) {
        z.reportln("RXTXPort:notifyOnDataAvailable( " + bl + " )");
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 1, bl);
        this.monThread.Data = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnOutputEmpty(boolean bl) {
        z.reportln("RXTXPort:notifyOnOutputEmpty( " + bl + " )");
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 2, bl);
        this.monThread.Output = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnCTS(boolean bl) {
        z.reportln("RXTXPort:notifyOnCTS( " + bl + " )");
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 3, bl);
        this.monThread.CTS = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnDSR(boolean bl) {
        z.reportln("RXTXPort:notifyOnDSR( " + bl + " )");
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 4, bl);
        this.monThread.DSR = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnRingIndicator(boolean bl) {
        z.reportln("RXTXPort:notifyOnRingIndicator( " + bl + " )");
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 5, bl);
        this.monThread.RI = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnCarrierDetect(boolean bl) {
        z.reportln("RXTXPort:notifyOnCarrierDetect( " + bl + " )");
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 6, bl);
        this.monThread.CD = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnOverrunError(boolean bl) {
        z.reportln("RXTXPort:notifyOnOverrunError( " + bl + " )");
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 7, bl);
        this.monThread.OE = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnParityError(boolean bl) {
        z.reportln("RXTXPort:notifyOnParityError( " + bl + " )");
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 8, bl);
        this.monThread.PE = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnFramingError(boolean bl) {
        z.reportln("RXTXPort:notifyOnFramingError( " + bl + " )");
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 9, bl);
        this.monThread.FE = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnBreakInterrupt(boolean bl) {
        z.reportln("RXTXPort:notifyOnBreakInterrupt( " + bl + " )");
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 10, bl);
        this.monThread.BI = bl;
        this.MonitorThreadLock = false;
    }

    private native void nativeClose(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        RXTXPort rXTXPort = this;
        synchronized (rXTXPort) {
            z.reportln("RXTXPort:close( " + this.name + " )");
            while (this.IOLocked > 0) {
                z.reportln("IO is locked " + this.IOLocked);
                try {
                    this.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            if (this.closeLock) {
                return;
            }
            this.closeLock = true;
        }
        if (this.fd <= 0) {
            z.reportln("RXTXPort:close detected bad File Descriptor");
            return;
        }
        this.setDTR(false);
        this.setDSR(false);
        z.reportln("RXTXPort:close( " + this.name + " ) setting monThreadisInterrupted");
        if (!this.monThreadisInterrupted) {
            this.removeEventListener();
        }
        z.reportln("RXTXPort:close( " + this.name + " ) calling nativeClose");
        this.nativeClose(this.name);
        z.reportln("RXTXPort:close( " + this.name + " ) calling super.close");
        super.close();
        this.fd = 0;
        this.closeLock = false;
        z.reportln("RXTXPort:close( " + this.name + " ) leaving");
    }

    protected void finalize() {
        z.reportln("RXTXPort:finalize()");
        if (this.fd > 0) {
            z.reportln("RXTXPort:calling close()");
            this.close();
        }
        z.finalize();
    }

    public void setRcvFifoTrigger(int n) {
    }

    private static native void nativeStaticSetSerialPortParams(String var0, int var1, int var2, int var3, int var4) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticSetDSR(String var0, boolean var1) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticSetDTR(String var0, boolean var1) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticSetRTS(String var0, boolean var1) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticIsDSR(String var0) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticIsDTR(String var0) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticIsRTS(String var0) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticIsCTS(String var0) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticIsCD(String var0) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticIsRI(String var0) throws UnsupportedCommOperationException;

    private static native int nativeStaticGetBaudRate(String var0) throws UnsupportedCommOperationException;

    private static native int nativeStaticGetDataBits(String var0) throws UnsupportedCommOperationException;

    private static native int nativeStaticGetParity(String var0) throws UnsupportedCommOperationException;

    private static native int nativeStaticGetStopBits(String var0) throws UnsupportedCommOperationException;

    private native byte nativeGetParityErrorChar() throws UnsupportedCommOperationException;

    private native boolean nativeSetParityErrorChar(byte var1) throws UnsupportedCommOperationException;

    private native byte nativeGetEndOfInputChar() throws UnsupportedCommOperationException;

    private native boolean nativeSetEndOfInputChar(byte var1) throws UnsupportedCommOperationException;

    private native boolean nativeSetUartType(String var1, boolean var2) throws UnsupportedCommOperationException;

    native String nativeGetUartType() throws UnsupportedCommOperationException;

    private native boolean nativeSetBaudBase(int var1) throws UnsupportedCommOperationException;

    private native int nativeGetBaudBase() throws UnsupportedCommOperationException;

    private native boolean nativeSetDivisor(int var1) throws UnsupportedCommOperationException;

    private native int nativeGetDivisor() throws UnsupportedCommOperationException;

    private native boolean nativeSetLowLatency() throws UnsupportedCommOperationException;

    private native boolean nativeGetLowLatency() throws UnsupportedCommOperationException;

    private native boolean nativeSetCallOutHangup(boolean var1) throws UnsupportedCommOperationException;

    private native boolean nativeGetCallOutHangup() throws UnsupportedCommOperationException;

    private native boolean nativeClearCommInput() throws UnsupportedCommOperationException;

    public static int staticGetBaudRate(String string) throws UnsupportedCommOperationException {
        z.reportln("RXTXPort:staticGetBaudRate( " + string + " )");
        return RXTXPort.nativeStaticGetBaudRate(string);
    }

    public static int staticGetDataBits(String string) throws UnsupportedCommOperationException {
        z.reportln("RXTXPort:staticGetDataBits( " + string + " )");
        return RXTXPort.nativeStaticGetDataBits(string);
    }

    public static int staticGetParity(String string) throws UnsupportedCommOperationException {
        z.reportln("RXTXPort:staticGetParity( " + string + " )");
        return RXTXPort.nativeStaticGetParity(string);
    }

    public static int staticGetStopBits(String string) throws UnsupportedCommOperationException {
        z.reportln("RXTXPort:staticGetStopBits( " + string + " )");
        return RXTXPort.nativeStaticGetStopBits(string);
    }

    public static void staticSetSerialPortParams(String string, int n, int n2, int n3, int n4) throws UnsupportedCommOperationException {
        z.reportln("RXTXPort:staticSetSerialPortParams( " + string + " " + n + " " + n2 + " " + n3 + " " + n4);
        RXTXPort.nativeStaticSetSerialPortParams(string, n, n2, n3, n4);
    }

    public static boolean staticSetDSR(String string, boolean bl) throws UnsupportedCommOperationException {
        z.reportln("RXTXPort:staticSetDSR( " + string + " " + bl);
        return RXTXPort.nativeStaticSetDSR(string, bl);
    }

    public static boolean staticSetDTR(String string, boolean bl) throws UnsupportedCommOperationException {
        z.reportln("RXTXPort:staticSetDTR( " + string + " " + bl);
        return RXTXPort.nativeStaticSetDTR(string, bl);
    }

    public static boolean staticSetRTS(String string, boolean bl) throws UnsupportedCommOperationException {
        z.reportln("RXTXPort:staticSetRTS( " + string + " " + bl);
        return RXTXPort.nativeStaticSetRTS(string, bl);
    }

    public static boolean staticIsRTS(String string) throws UnsupportedCommOperationException {
        z.reportln("RXTXPort:staticIsRTS( " + string + " )");
        return RXTXPort.nativeStaticIsRTS(string);
    }

    public static boolean staticIsCD(String string) throws UnsupportedCommOperationException {
        z.reportln("RXTXPort:staticIsCD( " + string + " )");
        return RXTXPort.nativeStaticIsCD(string);
    }

    public static boolean staticIsCTS(String string) throws UnsupportedCommOperationException {
        z.reportln("RXTXPort:staticIsCTS( " + string + " )");
        return RXTXPort.nativeStaticIsCTS(string);
    }

    public static boolean staticIsDSR(String string) throws UnsupportedCommOperationException {
        z.reportln("RXTXPort:staticIsDSR( " + string + " )");
        return RXTXPort.nativeStaticIsDSR(string);
    }

    public static boolean staticIsDTR(String string) throws UnsupportedCommOperationException {
        z.reportln("RXTXPort:staticIsDTR( " + string + " )");
        return RXTXPort.nativeStaticIsDTR(string);
    }

    public static boolean staticIsRI(String string) throws UnsupportedCommOperationException {
        z.reportln("RXTXPort:staticIsRI( " + string + " )");
        return RXTXPort.nativeStaticIsRI(string);
    }

    public byte getParityErrorChar() throws UnsupportedCommOperationException {
        z.reportln("getParityErrorChar()");
        byte by = this.nativeGetParityErrorChar();
        z.reportln("getParityErrorChar() returns " + by);
        return by;
    }

    public boolean setParityErrorChar(byte by) throws UnsupportedCommOperationException {
        z.reportln("setParityErrorChar(" + by + ")");
        return this.nativeSetParityErrorChar(by);
    }

    public byte getEndOfInputChar() throws UnsupportedCommOperationException {
        z.reportln("getEndOfInputChar()");
        byte by = this.nativeGetEndOfInputChar();
        z.reportln("getEndOfInputChar() returns " + by);
        return by;
    }

    public boolean setEndOfInputChar(byte by) throws UnsupportedCommOperationException {
        z.reportln("setEndOfInputChar(" + by + ")");
        return this.nativeSetEndOfInputChar(by);
    }

    public boolean setUARTType(String string, boolean bl) throws UnsupportedCommOperationException {
        z.reportln("RXTXPort:setUARTType()");
        return this.nativeSetUartType(string, bl);
    }

    public String getUARTType() throws UnsupportedCommOperationException {
        return this.nativeGetUartType();
    }

    public boolean setBaudBase(int n) throws UnsupportedCommOperationException, IOException {
        z.reportln("RXTXPort:setBaudBase()");
        return this.nativeSetBaudBase(n);
    }

    public int getBaudBase() throws UnsupportedCommOperationException, IOException {
        z.reportln("RXTXPort:getBaudBase()");
        return this.nativeGetBaudBase();
    }

    public boolean setDivisor(int n) throws UnsupportedCommOperationException, IOException {
        z.reportln("RXTXPort:setDivisor()");
        return this.nativeSetDivisor(n);
    }

    public int getDivisor() throws UnsupportedCommOperationException, IOException {
        z.reportln("RXTXPort:getDivisor()");
        return this.nativeGetDivisor();
    }

    public boolean setLowLatency() throws UnsupportedCommOperationException {
        z.reportln("RXTXPort:setLowLatency()");
        return this.nativeSetLowLatency();
    }

    public boolean getLowLatency() throws UnsupportedCommOperationException {
        z.reportln("RXTXPort:getLowLatency()");
        return this.nativeGetLowLatency();
    }

    public boolean setCallOutHangup(boolean bl) throws UnsupportedCommOperationException {
        z.reportln("RXTXPort:setCallOutHangup()");
        return this.nativeSetCallOutHangup(bl);
    }

    public boolean getCallOutHangup() throws UnsupportedCommOperationException {
        z.reportln("RXTXPort:getCallOutHangup()");
        return this.nativeGetCallOutHangup();
    }

    public boolean clearCommInput() throws UnsupportedCommOperationException {
        z.reportln("RXTXPort:clearCommInput()");
        return this.nativeClearCommInput();
    }

    static {
        try {
            z = new Zystem();
        }
        catch (Exception exception) {
            // empty catch block
        }
        z.reportln("RXTXPort {}");
        System.loadLibrary("rxtxSerial");
        RXTXPort.Initialize();
        dsrFlag = false;
    }

    class MonitorThread
    extends Thread {
        private volatile boolean CTS = false;
        private volatile boolean DSR = false;
        private volatile boolean RI = false;
        private volatile boolean CD = false;
        private volatile boolean OE = false;
        private volatile boolean PE = false;
        private volatile boolean FE = false;
        private volatile boolean BI = false;
        private volatile boolean Data = false;
        private volatile boolean Output = false;

        MonitorThread() {
            z.reportln("RXTXPort:MontitorThread:MonitorThread()");
        }

        public void run() {
            z.reportln("RXTXPort:MontitorThread:run()");
            RXTXPort.this.monThreadisInterrupted = false;
            RXTXPort.this.eventLoop();
            z.reportln("eventLoop() returned");
        }

        protected void finalize() throws Throwable {
            z.reportln("RXTXPort:MonitorThread exiting");
        }
    }

    class SerialInputStream
    extends InputStream {
        SerialInputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int read() throws IOException {
            Object object;
            int n;
            z.reportln("RXTXPort:SerialInputStream:read() called");
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                z.reportln("+++++++++ read() monThreadisInterrupted");
            }
            Object object2 = RXTXPort.this.IOLockedMutex;
            synchronized (object2) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                z.reportln("RXTXPort:SerialInputStream:read() L");
                RXTXPort.this.waitForTheNativeCodeSilly();
                z.reportln("RXTXPort:SerialInputStream:read() N");
                int n2 = RXTXPort.this.readByte();
                z.reportln("RXTXPort:SerialInputStream:read() returns");
                n = n2;
                Object var4_5 = null;
                object = RXTXPort.this.IOLockedMutex;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                Object object3 = RXTXPort.this.IOLockedMutex;
                synchronized (object3) {
                    --RXTXPort.this.IOLocked;
                }
                throw throwable;
            }
            synchronized (object) {
                --RXTXPort.this.IOLocked;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int read(byte[] byArray) throws IOException {
            Object object;
            int n;
            z.reportln("RXTXPort:SerialInputStream:read(" + byArray.length + ") called");
            if (RXTXPort.this.monThreadisInterrupted) {
                return 0;
            }
            Object object2 = RXTXPort.this.IOLockedMutex;
            synchronized (object2) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                RXTXPort.this.waitForTheNativeCodeSilly();
                int n2 = this.read(byArray, 0, byArray.length);
                z.reportln("RXTXPort:SerialInputStream:read() returned " + n2 + " bytes");
                n = n2;
                Object var6_6 = null;
                object = RXTXPort.this.IOLockedMutex;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                Object object3 = RXTXPort.this.IOLockedMutex;
                synchronized (object3) {
                    --RXTXPort.this.IOLocked;
                }
                throw throwable;
            }
            synchronized (object) {
                --RXTXPort.this.IOLocked;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            Object object;
            int n3;
            int n4;
            z.reportln("RXTXPort:SerialInputStream:read(" + byArray.length + " " + n + " " + n2 + ") called");
            if (RXTXPort.this.fd == 0) {
                z.reportln("RXTXPort:SerialInputStream:read() fd == 0");
                z.reportln("+++++++ IOException()\n");
                throw new IOException();
            }
            if (byArray == null) {
                z.reportln("+++++++ NullPointerException()\n");
                z.reportln("RXTXPort:SerialInputStream:read() b == 0");
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
                z.reportln("+++++++ IndexOutOfBoundsException()\n");
                z.reportln("RXTXPort:SerialInputStream:read() off < 0 ..");
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                z.reportln("RXTXPort:SerialInputStream:read() off < 0 ..");
                return 0;
            }
            int n5 = n2;
            n5 = RXTXPort.this.threshold == 0 ? ((n4 = RXTXPort.this.nativeavailable()) == 0 ? 1 : Math.min(n5, n4)) : Math.min(n5, RXTXPort.this.threshold);
            if (RXTXPort.this.monThreadisInterrupted) {
                z.reportln("RXTXPort:SerialInputStream:read() Interrupted");
                return 0;
            }
            Object object2 = RXTXPort.this.IOLockedMutex;
            synchronized (object2) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                RXTXPort.this.waitForTheNativeCodeSilly();
                int n6 = RXTXPort.this.readArray(byArray, n, n5);
                z.reportln("RXTXPort:SerialInputStream:read(" + byArray.length + " " + n + " " + n2 + ") returned " + n6 + " bytes");
                n3 = n6;
                Object var9_10 = null;
                object = RXTXPort.this.IOLockedMutex;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                Object object3 = RXTXPort.this.IOLockedMutex;
                synchronized (object3) {
                    --RXTXPort.this.IOLocked;
                }
                throw throwable;
            }
            synchronized (object) {
                --RXTXPort.this.IOLocked;
            }
            return n3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int read(byte[] byArray, int n, int n2, byte[] byArray2) throws IOException {
            Object object;
            int n3;
            int n4;
            z.reportln("RXTXPort:SerialInputStream:read(" + byArray.length + " " + n + " " + n2 + ") called");
            if (RXTXPort.this.fd == 0) {
                z.reportln("RXTXPort:SerialInputStream:read() fd == 0");
                z.reportln("+++++++ IOException()\n");
                throw new IOException();
            }
            if (byArray == null) {
                z.reportln("+++++++ NullPointerException()\n");
                z.reportln("RXTXPort:SerialInputStream:read() b == 0");
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
                z.reportln("+++++++ IndexOutOfBoundsException()\n");
                z.reportln("RXTXPort:SerialInputStream:read() off < 0 ..");
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                z.reportln("RXTXPort:SerialInputStream:read() off < 0 ..");
                return 0;
            }
            int n5 = n2;
            n5 = RXTXPort.this.threshold == 0 ? ((n4 = RXTXPort.this.nativeavailable()) == 0 ? 1 : Math.min(n5, n4)) : Math.min(n5, RXTXPort.this.threshold);
            if (RXTXPort.this.monThreadisInterrupted) {
                z.reportln("RXTXPort:SerialInputStream:read() Interrupted");
                return 0;
            }
            Object object2 = RXTXPort.this.IOLockedMutex;
            synchronized (object2) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                RXTXPort.this.waitForTheNativeCodeSilly();
                int n6 = RXTXPort.this.readTerminatedArray(byArray, n, n5, byArray2);
                z.reportln("RXTXPort:SerialInputStream:read(" + byArray.length + " " + n + " " + n2 + ") returned " + n6 + " bytes");
                n3 = n6;
                Object var10_11 = null;
                object = RXTXPort.this.IOLockedMutex;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                Object object3 = RXTXPort.this.IOLockedMutex;
                synchronized (object3) {
                    --RXTXPort.this.IOLocked;
                }
                throw throwable;
            }
            synchronized (object) {
                --RXTXPort.this.IOLocked;
            }
            return n3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int available() throws IOException {
            Object object;
            int n;
            if (RXTXPort.this.monThreadisInterrupted) {
                return 0;
            }
            z.reportln("RXTXPort:available() called");
            Object object2 = RXTXPort.this.IOLockedMutex;
            synchronized (object2) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                int n2 = RXTXPort.this.nativeavailable();
                z.reportln("RXTXPort:available() returning " + n2);
                n = n2;
                Object var4_5 = null;
                object = RXTXPort.this.IOLockedMutex;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                Object object3 = RXTXPort.this.IOLockedMutex;
                synchronized (object3) {
                    --RXTXPort.this.IOLocked;
                }
                throw throwable;
            }
            synchronized (object) {
                --RXTXPort.this.IOLocked;
            }
            return n;
        }
    }

    class SerialOutputStream
    extends OutputStream {
        SerialOutputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int n) throws IOException {
            Object object;
            z.reportln("RXTXPort:SerialOutputStream:write(int)");
            if (RXTXPort.this.speed == 0) {
                return;
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                return;
            }
            Object object2 = RXTXPort.this.IOLockedMutex;
            synchronized (object2) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                RXTXPort.this.waitForTheNativeCodeSilly();
                if (RXTXPort.this.fd == 0) {
                    throw new IOException();
                }
                RXTXPort.this.writeByte(n, RXTXPort.this.monThreadisInterrupted);
                z.reportln("Leaving RXTXPort:SerialOutputStream:write( int )");
                Object var5_4 = null;
                object = RXTXPort.this.IOLockedMutex;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                Object object3 = RXTXPort.this.IOLockedMutex;
                synchronized (object3) {
                    --RXTXPort.this.IOLocked;
                }
                throw throwable;
            }
            synchronized (object) {
                --RXTXPort.this.IOLocked;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] byArray) throws IOException {
            Object object;
            z.reportln("Entering RXTXPort:SerialOutputStream:write(" + byArray.length + ") ");
            if (RXTXPort.this.speed == 0) {
                return;
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                return;
            }
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            Object object2 = RXTXPort.this.IOLockedMutex;
            synchronized (object2) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                RXTXPort.this.waitForTheNativeCodeSilly();
                RXTXPort.this.writeArray(byArray, 0, byArray.length, RXTXPort.this.monThreadisInterrupted);
                z.reportln("Leaving RXTXPort:SerialOutputStream:write(" + byArray.length + ")");
                Object var5_4 = null;
                object = RXTXPort.this.IOLockedMutex;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                Object object3 = RXTXPort.this.IOLockedMutex;
                synchronized (object3) {
                    --RXTXPort.this.IOLocked;
                }
                throw throwable;
            }
            synchronized (object) {
                --RXTXPort.this.IOLocked;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] byArray, int n, int n2) throws IOException {
            Object object;
            if (RXTXPort.this.speed == 0) {
                return;
            }
            if (n + n2 > byArray.length) {
                throw new IndexOutOfBoundsException("Invalid offset/length passed to read");
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            z.reportln("Entering RXTXPort:SerialOutputStream:write(" + byArray2.length + " " + n + " " + n2 + " " + ") ");
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                return;
            }
            Object object2 = RXTXPort.this.IOLockedMutex;
            synchronized (object2) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                RXTXPort.this.waitForTheNativeCodeSilly();
                RXTXPort.this.writeArray(byArray2, 0, n2, RXTXPort.this.monThreadisInterrupted);
                z.reportln("Leaving RXTXPort:SerialOutputStream:write(" + byArray2.length + " " + n + " " + n2 + " " + ") ");
                Object var8_7 = null;
                object = RXTXPort.this.IOLockedMutex;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                Object object3 = RXTXPort.this.IOLockedMutex;
                synchronized (object3) {
                    --RXTXPort.this.IOLocked;
                }
                throw throwable;
            }
            synchronized (object) {
                --RXTXPort.this.IOLocked;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            Object object;
            z.reportln("RXTXPort:SerialOutputStream:flush() enter");
            if (RXTXPort.this.speed == 0) {
                return;
            }
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                z.reportln("RXTXPort:SerialOutputStream:flush() Leaving Interrupted");
                return;
            }
            Object object2 = RXTXPort.this.IOLockedMutex;
            synchronized (object2) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                RXTXPort.this.waitForTheNativeCodeSilly();
                if (RXTXPort.this.nativeDrain(RXTXPort.this.monThreadisInterrupted)) {
                    RXTXPort.this.sendEvent(2, true);
                }
                z.reportln("RXTXPort:SerialOutputStream:flush() leave");
                Object var4_3 = null;
                object = RXTXPort.this.IOLockedMutex;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                Object object3 = RXTXPort.this.IOLockedMutex;
                synchronized (object3) {
                    --RXTXPort.this.IOLocked;
                }
                throw throwable;
            }
            synchronized (object) {
                --RXTXPort.this.IOLocked;
            }
        }
    }
}

